#include <usb.h>
#include <usb_device_hid.h>

#include <string.h>

#include <system.h>

volatile unsigned char OUT_Buffer[64] @ HID_CUSTOM_OUT_DATA_BUFFER_ADDRESS;
volatile unsigned char IN_Buffer[64] @ HID_CUSTOM_IN_DATA_BUFFER_ADDRESS;

volatile USB_HANDLE USBOutHandle;    
volatile USB_HANDLE USBInHandle;

extern char lcd_data[16];
extern char settings[32];
extern char display_data[512];
extern uint8_t text_lenght;
extern LCD_CONFIGURATION LcdConfig;
extern volatile bool interrupt_pending;
extern uint8_t delay;
bool write = false;

void HIDInitialize(void)
{
    USBInHandle = 0;

    USBEnableEndpoint(CUSTOM_DEVICE_HID_EP, USB_IN_ENABLED|USB_OUT_ENABLED|USB_HANDSHAKE_ENABLED|USB_DISALLOW_SETUP);
    //USBInHandle = (volatile USB_HANDLE)HIDTxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&IN_Buffer,64);
    USBOutHandle = (volatile USB_HANDLE)HIDRxPacket(CUSTOM_DEVICE_HID_EP,(uint8_t*)&OUT_Buffer,64);
    HIDTxLED = 1;
    HIDRxLED = 1;
    
}

void HIDTasks(void)
{   

    uint8_t i = 0,j = 0;
    uint16_t k = 0;
    write = false;
    
    if(HIDRxHandleBusy(USBOutHandle) == false)
    {
        if(OUT_Buffer[0] == 0xAA)
        {
            LcdCmd(0x08);
            LcdBacklight(0);
            for(i = 0; i < 32; i++)
            {
                settings[i] = OUT_Buffer[i];
            }
            USBOutHandle = HIDRxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&OUT_Buffer, 64);    
            while (HIDRxHandleBusy(USBOutHandle) == true);
            for(i = 0; i < 8; i++)
            {
                if( HIDRxHandleBusy(USBOutHandle) == false)
                {
                    for(j = 0; j < 64; j++)
                    {
                        display_data[j+k] = OUT_Buffer[j];
                    }
                    k +=64;
 
                    
                    USBOutHandle = HIDRxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&OUT_Buffer, 64);  
                    if(i < 7) while (HIDRxHandleBusy(USBOutHandle) == true);
                }
            }

            IN_Buffer[0] = 0x55;
            USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&IN_Buffer[0],64);
            while (HIDTxHandleBusy(USBInHandle) == true);

            USBDeviceDetach();
            OSCCON = 0x34;
            FlashErase(0x1DE0, 554);
            FlashWrite(&display_data,0x1E00,512);
            FlashWrite(&settings,0x1DE0, 32);
            OSCCON = 0xFC;
            FlashToRam();
            USBDeviceAttach();
            while (USBGetDeviceState() < CONFIGURED_STATE);
            while (HIDRxHandleBusy(USBOutHandle) == true);
            if(OUT_Buffer[0] == 0x55)
            {
                if(HIDTxHandleBusy(USBInHandle) == false)
                {
                    IN_Buffer[0] = settings[0];
                    USBInHandle = HIDTxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&IN_Buffer[0],64);
                    while (HIDTxHandleBusy(USBInHandle) == true);
                }
            }
            for(uint8_t i = 0; i < 16; i++)
            {
                lcd_data[i] = 0;
            }
            LcdCmd(0x0C);
            LcdBacklight(LcdConfig.BACKLIGHT);
        }
        USBOutHandle = HIDRxPacket(CUSTOM_DEVICE_HID_EP, (uint8_t*)&OUT_Buffer, 64);  
        interrupt_pending = false;
    }
}